/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.action.CompositeAction;
import org.jdesktop.swingx.action.ServerAction;
import org.jdesktop.swingx.action.TargetableAction;

public class ActionManager {
    private Map actionMap;
    private ActionContainerFactory factory;
    private static ActionManager INSTANCE;
    private static boolean DEBUG;

    public ActionContainerFactory getFactory() {
        if (this.factory == null) {
            this.factory = new ActionContainerFactory(this);
        }
        return this.factory;
    }

    public void setFactory(ActionContainerFactory factory) {
        this.factory = factory;
    }

    public static ActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionManager();
        }
        return INSTANCE;
    }

    public static void setInstance(ActionManager manager) {
        INSTANCE = manager;
    }

    public Set getActionIDs() {
        if (this.actionMap == null) {
            return null;
        }
        return this.actionMap.keySet();
    }

    public Action addAction(Action action) {
        return this.addAction(action.getValue("ActionCommandKey"), action);
    }

    public Action addAction(Object id, Action action) {
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
        }
        this.actionMap.put(id, action);
        return action;
    }

    public Action getAction(Object id) {
        if (this.actionMap != null) {
            return (Action)this.actionMap.get(id);
        }
        return null;
    }

    public TargetableAction getTargetableAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof TargetableAction) {
            return (TargetableAction)a;
        }
        return null;
    }

    public BoundAction getBoundAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof BoundAction) {
            return (BoundAction)a;
        }
        return null;
    }

    public ServerAction getServerAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof ServerAction) {
            return (ServerAction)a;
        }
        return null;
    }

    public CompositeAction getCompositeAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof CompositeAction) {
            return (CompositeAction)a;
        }
        return null;
    }

    private AbstractActionExt getStateChangeAction(Object id) {
        AbstractActionExt aa;
        Action a = this.getAction(id);
        if (a != null && a instanceof AbstractActionExt && (aa = (AbstractActionExt)a).isStateAction()) {
            return aa;
        }
        return null;
    }

    public void setEnabled(Object id, boolean enabled) {
        Action action = this.getAction(id);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public boolean isEnabled(Object id) {
        Action action = this.getAction(id);
        if (action != null) {
            return action.isEnabled();
        }
        return false;
    }

    public void setSelected(Object id, boolean selected) {
        AbstractActionExt action = this.getStateChangeAction(id);
        if (action != null) {
            action.setSelected(selected);
        }
    }

    public boolean isSelected(Object id) {
        AbstractActionExt action = this.getStateChangeAction(id);
        if (action != null) {
            return action.isSelected();
        }
        return false;
    }

    static void printAction(PrintStream stream, Action action) {
        stream.println("Attributes for " + action.getValue("ActionCommandKey"));
        if (action instanceof AbstractAction) {
            Object[] keys = ((AbstractAction)action).getKeys();
            for (int i = 0; i < keys.length; ++i) {
                stream.println("\tkey: " + keys[i] + "\tvalue: " + action.getValue((String)keys[i]));
            }
        }
    }

    public void registerCallback(Object id, Object handler, String method) {
        BoundAction action = this.getBoundAction(id);
        if (action != null) {
            action.registerCallback(handler, method);
        }
    }

    public boolean isStateAction(Object id) {
        Action action = this.getAction(id);
        if (action != null && action instanceof AbstractActionExt) {
            return ((AbstractActionExt)action).isStateAction();
        }
        return false;
    }

    public boolean isTargetableAction(Object id) {
        return this.getTargetableAction(id) != null;
    }

    public boolean isBoundAction(Object id) {
        return this.getBoundAction(id) != null;
    }

    public boolean isCompositeAction(Object id) {
        return this.getCompositeAction(id) != null;
    }

    public boolean isServerAction(Object id) {
        return this.getServerAction(id) != null;
    }

    static {
        DEBUG = false;
    }
}

