/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.Comparator;
import org.jdesktop.swingx.decorator.Sorter;

public class ShuttleSorter
extends Sorter {
    private int[] toPrevious;

    public ShuttleSorter() {
        this(0, true);
    }

    public ShuttleSorter(int col, boolean ascending) {
        super(col, ascending);
    }

    public ShuttleSorter(int col, boolean ascending, Comparator comparator) {
        super(col, ascending, comparator);
    }

    protected void init() {
        this.toPrevious = new int[0];
    }

    protected void adopt(Sorter oldSorter) {
        if (oldSorter != null) {
            this.toPrevious = (int[])((ShuttleSorter)oldSorter).toPrevious.clone();
            this.fromPrevious = (int[])((ShuttleSorter)oldSorter).fromPrevious.clone();
        }
    }

    protected void reset() {
        int inputSize = this.getInputSize();
        this.toPrevious = new int[inputSize];
        this.fromPrevious = new int[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            this.toPrevious[i] = i;
        }
    }

    protected void filter() {
        this.sort((int[])this.toPrevious.clone(), this.toPrevious, 0, this.toPrevious.length);
        for (int i = 0; i < this.toPrevious.length; ++i) {
            this.fromPrevious[this.toPrevious[i]] = i;
        }
    }

    public int getSize() {
        return this.toPrevious.length;
    }

    protected int mapTowardModel(int row) {
        return this.toPrevious[row];
    }

    protected void sort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = low + high >> 1;
        this.sort(to, from, low, middle);
        this.sort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }
}

