/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.swingx.JavaBean;
import org.jdesktop.swingx.painter.Effect;
import org.jdesktop.swingx.painter.ImageEffect;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.PaintUtils;
import org.jdesktop.swingx.util.Resize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPainter<T extends JComponent>
extends JavaBean
implements Painter<T> {
    private boolean stateSaved = false;
    private Paint oldPaint;
    private Font oldFont;
    private Stroke oldStroke;
    private AffineTransform oldTransform;
    private Composite oldComposite;
    private Shape oldClip;
    private Color oldBackground;
    private Color oldColor;
    private RenderingHints oldRenderingHints;
    private Shape clip;
    private Resize resizeClip = Resize.BOTH;
    private Composite composite;
    private Map<RenderingHints.Key, Object> renderingHints;
    private boolean useCache = false;
    private SoftReference<BufferedImage> cachedImage;
    private Effect[] effects = new Effect[0];

    public AbstractPainter() {
        this.renderingHints = new HashMap<RenderingHints.Key, Object>();
    }

    public void setUseCache(boolean b) {
        boolean old = this.isUseCache();
        this.useCache = b;
        this.firePropertyChange("useCache", old, this.isUseCache());
        if (this.cachedImage != null && !this.isUseCache()) {
            this.cachedImage = null;
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setEffects(Effect ... effects) {
        Effect[] old = this.getEffects();
        this.effects = new Effect[effects == null ? 0 : effects.length];
        if (effects != null) {
            System.arraycopy(effects, 0, this.effects, 0, effects.length);
        }
        this.firePropertyChange("effects", old, this.getEffects());
        this.firePropertyChange("effects", old, this.getEffects());
    }

    public void setEffects(BufferedImageOp ... filters) {
        Effect[] effects = new Effect[filters == null ? 0 : filters.length];
        if (filters != null) {
            int index = 0;
            for (BufferedImageOp op : filters) {
                effects[index++] = new ImageEffect(op);
            }
        }
        this.setEffects(effects);
    }

    public Effect[] getEffects() {
        Effect[] results = new Effect[this.effects.length];
        System.arraycopy(this.effects, 0, results, 0, results.length);
        return results;
    }

    public void setClip(Shape clip) {
        Shape old = this.getClip();
        this.clip = clip;
        this.firePropertyChange("clip", old, this.getClip());
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setResizeClip(Resize r) {
        Resize old = this.getResizeClip();
        this.resizeClip = r == null ? Resize.NONE : r;
        this.firePropertyChange("resizeClip", (Object)old, (Object)this.getResizeClip());
    }

    public Resize getResizeClip() {
        return this.resizeClip;
    }

    public void setComposite(Composite c) {
        Composite old = this.getComposite();
        this.composite = c;
        this.firePropertyChange("composite", old, this.getComposite());
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Object getAlphaInterpolation() {
        return this.renderingHints.get(RenderingHints.KEY_ALPHA_INTERPOLATION);
    }

    public void setAlphaInterpolation(Object alphaInterpolation) {
        if (alphaInterpolation != null && !RenderingHints.KEY_ALPHA_INTERPOLATION.isCompatibleValue(alphaInterpolation)) {
            throw new IllegalArgumentException(alphaInterpolation + " is not an acceptable value");
        }
        Object old = this.getAlphaInterpolation();
        this.renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, alphaInterpolation);
        this.firePropertyChange("alphaInterpolation", old, this.getAlphaInterpolation());
    }

    public Object getAntialiasing() {
        return this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
    }

    public void setAntialiasing(Object antialiasing) {
        if (antialiasing != null && !RenderingHints.KEY_ANTIALIASING.isCompatibleValue(antialiasing)) {
            throw new IllegalArgumentException(antialiasing + " is not an acceptable value");
        }
        Object old = this.getAntialiasing();
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, antialiasing);
        this.firePropertyChange("antialiasing", old, this.getAntialiasing());
    }

    public Object getColorRendering() {
        return this.renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
    }

    public void setColorRendering(Object colorRendering) {
        if (colorRendering != null && !RenderingHints.KEY_COLOR_RENDERING.isCompatibleValue(colorRendering)) {
            throw new IllegalArgumentException(colorRendering + " is not an acceptable value");
        }
        Object old = this.getColorRendering();
        this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, colorRendering);
        this.firePropertyChange("colorRendering", old, this.getColorRendering());
    }

    public Object getDithering() {
        return this.renderingHints.get(RenderingHints.KEY_DITHERING);
    }

    public void setDithering(Object dithering) {
        if (dithering != null && !RenderingHints.KEY_DITHERING.isCompatibleValue(dithering)) {
            throw new IllegalArgumentException(dithering + " is not an acceptable value");
        }
        Object old = this.getDithering();
        this.renderingHints.put(RenderingHints.KEY_DITHERING, dithering);
        this.firePropertyChange("dithering", old, this.getDithering());
    }

    public Object getFractionalMetrics() {
        return this.renderingHints.get(RenderingHints.KEY_FRACTIONALMETRICS);
    }

    public void setFractionalMetrics(Object fractionalMetrics) {
        if (fractionalMetrics != null && !RenderingHints.KEY_FRACTIONALMETRICS.isCompatibleValue(fractionalMetrics)) {
            throw new IllegalArgumentException(fractionalMetrics + " is not an acceptable value");
        }
        Object old = this.getFractionalMetrics();
        this.renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, fractionalMetrics);
        this.firePropertyChange("fractionalMetrics", old, this.getFractionalMetrics());
    }

    public Object getInterpolation() {
        return this.renderingHints.get(RenderingHints.KEY_INTERPOLATION);
    }

    public void setInterpolation(Object interpolation) {
        if (interpolation != null && !RenderingHints.KEY_INTERPOLATION.isCompatibleValue(interpolation)) {
            throw new IllegalArgumentException(interpolation + " is not an acceptable value");
        }
        Object old = this.getInterpolation();
        this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, interpolation);
        this.firePropertyChange("interpolation", old, this.getInterpolation());
    }

    public Object getRendering() {
        return this.renderingHints.get(RenderingHints.KEY_RENDERING);
    }

    public void setRendering(Object rendering) {
        if (rendering != null && !RenderingHints.KEY_RENDERING.isCompatibleValue(rendering)) {
            throw new IllegalArgumentException(rendering + " is not an acceptable value");
        }
        Object old = this.getRendering();
        this.renderingHints.put(RenderingHints.KEY_RENDERING, rendering);
        this.firePropertyChange("rendering", old, this.getRendering());
    }

    public Object getStrokeControl() {
        return this.renderingHints.get(RenderingHints.KEY_STROKE_CONTROL);
    }

    public void setStrokeControl(Object strokeControl) {
        if (strokeControl != null && !RenderingHints.KEY_STROKE_CONTROL.isCompatibleValue(strokeControl)) {
            throw new IllegalArgumentException(strokeControl + " is not an acceptable value");
        }
        Object old = this.getStrokeControl();
        this.renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, strokeControl);
        this.firePropertyChange("strokeControl", old, this.getStrokeControl());
    }

    public Object getTextAntialiasing() {
        return this.renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
    }

    public void setTextAntialiasing(Object textAntialiasing) {
        if (textAntialiasing != null && !RenderingHints.KEY_TEXT_ANTIALIASING.isCompatibleValue(textAntialiasing)) {
            throw new IllegalArgumentException(textAntialiasing + " is not an acceptable value");
        }
        Object old = this.getTextAntialiasing();
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, textAntialiasing);
        this.firePropertyChange("textAntialiasing", old, this.getTextAntialiasing());
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object hint) {
        if (key == RenderingHints.KEY_ALPHA_INTERPOLATION) {
            this.setAlphaInterpolation(hint);
        } else if (key == RenderingHints.KEY_ANTIALIASING) {
            this.setAntialiasing(hint);
        } else if (key == RenderingHints.KEY_COLOR_RENDERING) {
            this.setColorRendering(hint);
        } else if (key == RenderingHints.KEY_DITHERING) {
            this.setDithering(hint);
        } else if (key == RenderingHints.KEY_FRACTIONALMETRICS) {
            this.setFractionalMetrics(hint);
        } else if (key == RenderingHints.KEY_INTERPOLATION) {
            this.setInterpolation(hint);
        } else if (key == RenderingHints.KEY_RENDERING) {
            this.setRendering(hint);
        } else if (key == RenderingHints.KEY_STROKE_CONTROL) {
            this.setStrokeControl(hint);
        } else if (key == RenderingHints.KEY_TEXT_ANTIALIASING) {
            this.setTextAntialiasing(hint);
        } else {
            this.renderingHints.put(key, hint);
        }
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return new HashMap<RenderingHints.Key, Object>(this.renderingHints);
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> renderingHints) {
        this.renderingHints = renderingHints != null ? new HashMap<RenderingHints.Key, Object>(renderingHints) : new HashMap<RenderingHints.Key, Object>();
        this.firePropertyChange("renderingHints", null, this.getRenderingHints());
    }

    protected void saveState(Graphics2D g) {
        this.oldPaint = g.getPaint();
        this.oldFont = g.getFont();
        this.oldStroke = g.getStroke();
        this.oldTransform = g.getTransform();
        this.oldComposite = g.getComposite();
        this.oldClip = g.getClip();
        this.oldBackground = g.getBackground();
        this.oldColor = g.getColor();
        this.oldRenderingHints = (RenderingHints)g.getRenderingHints().clone();
        this.stateSaved = true;
    }

    protected void restoreState(Graphics2D g) {
        if (!this.stateSaved) {
            throw new IllegalStateException("A call to saveState must occur prior to calling restoreState");
        }
        g.setPaint(this.oldPaint);
        g.setFont(this.oldFont);
        g.setTransform(this.oldTransform);
        g.setStroke(this.oldStroke);
        g.setComposite(this.oldComposite);
        g.setClip(this.oldClip);
        g.setBackground(this.oldBackground);
        g.setColor(this.oldColor);
        g.setRenderingHints(this.oldRenderingHints);
        this.stateSaved = false;
    }

    @Override
    public void paint(Graphics2D g, T component) {
        BufferedImage image;
        this.saveState(g);
        this.configureGraphics(g, component);
        BufferedImage bufferedImage = image = this.cachedImage == null ? null : this.cachedImage.get();
        if (this.isUseCache() && image != null && image.getWidth() == ((JComponent)component).getWidth() && image.getHeight() == ((JComponent)component).getHeight()) {
            g.drawImage((Image)image, 0, 0, null);
        } else {
            Effect[] effects = this.getEffects();
            if (effects.length > 0 || this.isUseCache()) {
                image = PaintUtils.createCompatibleImage(((JComponent)component).getWidth(), ((JComponent)component).getHeight(), 3);
                Graphics2D gfx = image.createGraphics();
                this.configureGraphics(gfx, component);
                this.paintBackground(gfx, component);
                gfx.dispose();
                for (Effect effect : effects) {
                    image = effect.apply(image);
                }
                g.drawImage((Image)image, 0, 0, null);
                if (this.isUseCache()) {
                    this.cachedImage = new SoftReference<BufferedImage>(image);
                }
            } else {
                this.paintBackground(g, component);
            }
        }
        this.restoreState(g);
    }

    private void configureGraphics(Graphics2D g, T c) {
        Shape clip;
        Map<RenderingHints.Key, Object> hints = this.getRenderingHints();
        for (RenderingHints.Key key : hints.keySet()) {
            Object value = hints.get(key);
            if (value == null) continue;
            g.setRenderingHint(key, hints.get(key));
        }
        if (this.getComposite() != null) {
            g.setComposite(this.getComposite());
        }
        if ((clip = this.getClip()) != null) {
            double width = 1.0;
            double height = 1.0;
            Resize resizeClip = this.getResizeClip();
            if (resizeClip == Resize.HORIZONTAL || resizeClip == Resize.BOTH) {
                width = ((JComponent)c).getWidth();
            }
            if (resizeClip == Resize.VERTICAL || resizeClip == Resize.BOTH) {
                height = ((JComponent)c).getHeight();
            }
            if (clip instanceof RoundRectangle2D) {
                RoundRectangle2D rect = (RoundRectangle2D)clip;
                clip = new RoundRectangle2D.Double(rect.getX(), rect.getY(), width, height, rect.getArcWidth(), rect.getArcHeight());
            } else {
                clip = AffineTransform.getScaleInstance(width, height).createTransformedShape(clip);
            }
            g.setClip(clip);
        }
    }

    protected abstract void paintBackground(Graphics2D var1, T var2);
}

