/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

public class PinstripePainter
extends AbstractPainter {
    private double angle = 45.0;
    private double spacing = 8.0;
    private Paint paint;

    public PinstripePainter() {
    }

    public PinstripePainter(Paint paint) {
        this(paint, 45.0);
    }

    public PinstripePainter(Paint paint, double angle) {
        this.paint = paint;
        this.angle = angle;
    }

    public PinstripePainter(double angle) {
        this.angle = angle;
    }

    public void setPaint(Paint p) {
        Paint old = this.getPaint();
        this.paint = p;
        this.firePropertyChange("paint", old, this.getPaint());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setAngle(double angle) {
        if (angle > 360.0) {
            angle %= 360.0;
        }
        if (angle < 0.0) {
            angle = 360.0 - angle * -1.0 % 360.0;
        }
        double old = this.getAngle();
        this.angle = angle;
        this.firePropertyChange("angle", old, this.getAngle());
    }

    public double getAngle() {
        return this.angle;
    }

    public void setSpacing(double spacing) {
        double old = this.getSpacing();
        this.spacing = spacing;
        this.firePropertyChange("spacing", old, this.getSpacing());
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void paintBackground(Graphics2D g, JComponent component) {
        Paint p = this.getPaint();
        if (p == null) {
            g.setColor(component.getForeground());
        } else {
            g.setPaint(p);
        }
        double hypLength = Math.sqrt(component.getWidth() * component.getWidth() + component.getHeight() * component.getHeight());
        double radians = Math.toRadians(this.getAngle());
        g.rotate(radians);
        int numLines = (int)(hypLength / this.getSpacing());
        for (int i = 0; i < numLines; ++i) {
            double x = (double)i * this.getSpacing();
            Line2D.Double line = new Line2D.Double(x, -hypLength, x, hypLength);
            g.draw(line);
        }
    }
}

