/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnControlButton
extends JButton {
    protected JPopupMenu popupMenu = null;
    private JXTable table;
    public static final String COLUMN_CONTROL_MARKER = "column.";
    private List<ColumnVisibilityAction> columnVisibilityActions;
    private PropertyChangeListener columnModelChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("columnModel".equals(evt.getPropertyName())) {
                ColumnControlButton.this.updateFromColumnModelChange((TableColumnModel)evt.getOldValue());
            } else if ("enabled".equals(evt.getPropertyName())) {
                ColumnControlButton.this.updateFromTableEnabledChanged();
            }
        }
    };
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){

        public void columnAdded(TableColumnModelEvent e) {
            if (!this.isVisibilityChange(e, true)) {
                ColumnControlButton.this.populatePopupMenu();
            }
        }

        public void columnRemoved(TableColumnModelEvent e) {
            if (!this.isVisibilityChange(e, false)) {
                ColumnControlButton.this.populatePopupMenu();
            }
        }

        private boolean isVisibilityChange(TableColumnModelEvent e, boolean added) {
            if (!(e.getSource() instanceof DefaultTableColumnModelExt)) {
                return false;
            }
            DefaultTableColumnModelExt model = (DefaultTableColumnModelExt)e.getSource();
            if (added) {
                return model.isAddedFromInvisibleEvent(e.getToIndex());
            }
            return model.isRemovedToInvisibleEvent(e.getFromIndex());
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    };

    public ColumnControlButton(JXTable table, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.installTable(table);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setMargin(new Insets(1, 2, 2, 1));
        if (this.popupMenu != null) {
            this.popupMenu.updateUI();
        }
    }

    public void togglePopup() {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        } else if (this.popupMenu.getComponentCount() > 0) {
            Dimension buttonSize = this.getSize();
            int xPos = this.getComponentOrientation().isLeftToRight() ? buttonSize.width - this.popupMenu.getPreferredSize().width : 0;
            this.popupMenu.show(this, xPos, buttonSize.height);
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.popupMenu.applyComponentOrientation(o);
    }

    protected void updateFromColumnModelChange(TableColumnModel oldModel) {
        if (oldModel != null) {
            oldModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopupMenu();
        if (this.canControl()) {
            this.table.getColumnModel().addColumnModelListener(this.columnModelListener);
        }
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    protected boolean canControl() {
        return this.table.getColumnModel() instanceof TableColumnModelExt;
    }

    protected void populatePopupMenu() {
        this.clearPopupMenu();
        if (this.canControl()) {
            this.addColumnMenuItems();
        }
        this.addColumnActions();
    }

    private void clearPopupMenu() {
        this.clearColumnVisibilityActions();
        this.popupMenu.removeAll();
    }

    private void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        Iterator<ColumnVisibilityAction> iter = this.columnVisibilityActions.iterator();
        while (iter.hasNext()) {
            iter.next().releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    private void addColumnMenuItems() {
        List<TableColumn> columns = this.table.getColumns(true);
        ActionContainerFactory factory = new ActionContainerFactory(null);
        Iterator<TableColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            ColumnVisibilityAction action = new ColumnVisibilityAction(iter.next());
            this.getColumnVisibilityActions().add(action);
            this.popupMenu.add(factory.createMenuItem(action));
        }
    }

    private List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    private void addColumnActions() {
        Object[] actionKeys = this.getColumnControlActionKeys();
        Arrays.sort(actionKeys);
        ArrayList<Action> actions = new ArrayList<Action>();
        for (int i = 0; i < actionKeys.length; ++i) {
            if (!this.isColumnControlActionKey(actionKeys[i])) continue;
            actions.add(this.table.getActionMap().get(actionKeys[i]));
        }
        if (actions.size() == 0) {
            return;
        }
        if (this.canControl()) {
            this.popupMenu.addSeparator();
        }
        ActionContainerFactory factory = new ActionContainerFactory(null);
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            this.popupMenu.add(factory.createMenuItem((Action)iter.next()));
        }
    }

    private Object[] getColumnControlActionKeys() {
        Object[] allKeys = this.table.getActionMap().allKeys();
        ArrayList<Object> columnKeys = new ArrayList<Object>();
        for (int i = 0; i < allKeys.length; ++i) {
            if (!this.isColumnControlActionKey(allKeys[i])) continue;
            columnKeys.add(allKeys[i]);
        }
        return columnKeys.toArray();
    }

    private boolean isColumnControlActionKey(Object actionKey) {
        return actionKey instanceof String && ((String)actionKey).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(JXTable table) {
        this.table = table;
        table.addPropertyChangeListener(this.columnModelChangeListener);
        this.updateFromColumnModelChange(null);
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.popupMenu = new JPopupMenu();
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
    }

    private Action createControlAction(Icon icon) {
        AbstractAction control = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ColumnControlButton.this.togglePopup();
            }
        };
        control.putValue("SmallIcon", icon);
        return control;
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private TableColumn column;
        private PropertyChangeListener columnListener;
        private boolean fromColumn;

        public ColumnVisibilityAction(TableColumn column) {
            super((String)null);
            this.setStateAction();
            this.installColumn(column);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.canControl();
        }

        private boolean canControl() {
            return this.column instanceof TableColumnExt;
        }

        public void itemStateChanged(ItemEvent e) {
            if (this.canControl()) {
                if (e.getStateChange() == 2 && ColumnControlButton.this.table.getColumnCount() <= 1 && !this.fromColumn) {
                    this.reselect();
                } else {
                    ((TableColumnExt)this.column).setVisible(e.getStateChange() == 1);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
        }

        private void updateSelected() {
            boolean visible = true;
            if (this.canControl()) {
                visible = ((TableColumnExt)this.column).isVisible();
            }
            this.fromColumn = true;
            this.setSelected(visible);
            this.fromColumn = false;
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn column) {
            this.column = column;
            column.addPropertyChangeListener(this.getColumnListener());
            this.setName(String.valueOf(column.getHeaderValue()));
            this.setActionCommand(column.getIdentifier());
            this.updateSelected();
        }

        private PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        private PropertyChangeListener createPropertyChangeListener() {
            PropertyChangeListener l = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("visible".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateSelected();
                    } else if ("headerValue".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.setName(String.valueOf(evt.getNewValue()));
                    }
                }
            };
            return l;
        }
    }
}

