/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private static final String IGNORE_EVENT = "TableColumnModelExt.ignoreEvent";
    private List<TableColumn> allColumns = new ArrayList<TableColumn>();
    private Set<TableColumnExt> invisibleColumns = new HashSet<TableColumnExt>();
    private Map<TableColumnExt, Integer> oldIndexes = new HashMap<TableColumnExt, Integer>();
    private VisibilityListener visibilityListener = new VisibilityListener();

    @Override
    public List<TableColumn> getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList<TableColumn>(this.allColumns);
        }
        return Collections.list(this.getColumns());
    }

    @Override
    public int getColumnCount(boolean includeHidden) {
        if (includeHidden) {
            return this.allColumns.size();
        }
        return this.getColumnCount();
    }

    @Override
    public TableColumnExt getColumnExt(Object identifier) {
        for (TableColumn column : this.allColumns) {
            if (!(column instanceof TableColumnExt) || !identifier.equals(column.getIdentifier())) continue;
            return (TableColumnExt)column;
        }
        return null;
    }

    @Override
    public Set<TableColumnExt> getInvisibleColumns() {
        return new HashSet<TableColumnExt>(this.invisibleColumns);
    }

    public boolean isRemovedToInvisibleEvent(int oldIndex) {
        return this.oldIndexes.containsValue(oldIndex);
    }

    public boolean isAddedFromInvisibleEvent(int newIndex) {
        if (!(this.getColumn(newIndex) instanceof TableColumnExt)) {
            return false;
        }
        return Boolean.TRUE.equals(((TableColumnExt)this.getColumn(newIndex)).getClientProperty(IGNORE_EVENT));
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (column instanceof TableColumnExt) {
            ((TableColumnExt)column).removePropertyChangeListener(this.visibilityListener);
        }
        this.invisibleColumns.remove(column);
        this.allColumns.remove(column);
        this.oldIndexes.remove(column);
        super.removeColumn(column);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        boolean oldVisible = true;
        if (aColumn instanceof TableColumnExt) {
            TableColumnExt xColumn = (TableColumnExt)aColumn;
            oldVisible = xColumn.isVisible();
            xColumn.setVisible(true);
            xColumn.addPropertyChangeListener(this.visibilityListener);
        }
        this.allColumns.add(aColumn);
        super.addColumn(aColumn);
        if (aColumn instanceof TableColumnExt) {
            ((TableColumnExt)aColumn).setVisible(oldVisible);
        }
    }

    protected void moveToInvisible(TableColumnExt col) {
        this.invisibleColumns.add(col);
        this.oldIndexes.put(col, this.tableColumns.indexOf(col));
        super.removeColumn(col);
    }

    protected void moveToVisible(TableColumnExt col) {
        this.invisibleColumns.remove(col);
        Integer oldIndex = this.oldIndexes.get(col);
        if (oldIndex == null) {
            oldIndex = this.getColumnCount();
        }
        this.oldIndexes.remove(col);
        col.putClientProperty(IGNORE_EVENT, Boolean.TRUE);
        super.addColumn(col);
        this.moveColumn(this.getColumnCount() - 1, Math.min(this.getColumnCount() - 1, oldIndex));
        col.putClientProperty(IGNORE_EVENT, null);
    }

    protected EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.fireColumnPropertyChange(evt);
    }

    protected void fireColumnPropertyChange(PropertyChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelExtListener.class) continue;
            ((TableColumnModelExtListener)listeners[i + 1]).columnPropertyChange(evt);
        }
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener x) {
        super.addColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.add(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener x) {
        super.removeColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.remove(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    private final class VisibilityListener
    implements PropertyChangeListener {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                boolean oldValue = (Boolean)evt.getOldValue();
                boolean newValue = (Boolean)evt.getNewValue();
                TableColumnExt col = (TableColumnExt)evt.getSource();
                if (oldValue && !newValue) {
                    DefaultTableColumnModelExt.this.moveToInvisible(col);
                } else if (!oldValue && newValue) {
                    DefaultTableColumnModelExt.this.moveToVisible(col);
                }
            }
        }
    }
}

